﻿using System;
using System.Collections.Generic;
using System.Web.UI;
using VIRP.EFR.DAL;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Controls.Custom.EFR
{
    public partial class DoDFragmentDetail : VIRP_WEB.BaseCode.BaseControl
    {
        DoDFragmentDB manager = new DoDFragmentDB();

        protected void Page_Load(object sender, EventArgs e)
        {
            LoadBaseControls();

            // Added for 508 compliance with GridView column headers and footer
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewAnalyteData.ClientID + "');", true);
        }

        protected void Page_PreRender(object sender, EventArgs e)
        {
            LoadControlsFromObject();
        }

        public string FragmentID
        {
            set
            {
                HiddenFieldFragmentID.Value = value;
            }
        }

        public string PatientID
        {
            set
            {
                HiddenFieldPatientID.Value = value;
            }
        }

        private void LoadControlsFromObject()
        {
            DOD_FRAGMENT fragment = manager.GetDoDFragmentById(Helpers.GetIntFromString(HiddenFieldFragmentID.Value));

            if (fragment != null)
            {
                BaseControlLabelFragmentID.Text = fragment.FRAGMENT_ID_NUMBER;
                BaseControlLabelFragmentDesc.Text = fragment.FRAGMENT_DESCRIPTION;
                BaseControlLabelFragmentMass.Text = fragment.MASS;
                BaseControlLabelFragmentMassUOM.Text = fragment.MASS_UNITS;
                BaseControlLabelFragmentLength.Text = fragment.LENGTH;
                BaseControlLabelFragmentLengthUOM.Text = fragment.LENGTH_UNITS;
                BaseControlLabelFragmentHeight.Text = fragment.HEIGHT;
                BaseControlLabelFragmentHeightUOM.Text = fragment.HEIGHT_UNITS;
                BaseControlLabelFragmentWidth.Text = fragment.WIDTH;
                BaseControlLabelFragmentWidthUOM.Text = fragment.WIDTH_UNITS;
                BaseControlLabelFragmentRadioActiveInd.Text = fragment.RADIOACTIVEINDICATOR;
                BaseControlLabelFragmentRadioActiveResults.Text = fragment.RADIOACTIVERESULTS;
                BaseControlLabelFragmentComments.Text = fragment.COMMENTS;
                if (fragment.TISSUE_SENT_FLAG.HasValue)
                {
                    BaseControlLabelFragmentTissueIndicator.Text = fragment.TISSUE_SENT_FLAG == true ? "Yes" : "No";
                }
                BaseControlLabelFragmentTissueAssociated.Text = fragment.TISSUE_ASSOCIATED_WITH_FRAGMENT;

                HiddenFieldLabID.Value = fragment.DOD_FRAGMENT_LAB_ID.ToString();
            }
        }

        private void LoadBaseControls()
        {
            CommonManager commonManager = new CommonManager();
            List<STD_GUI_CONTROL> controls = commonManager.GetStdGuiControlsByCategory("DOD_FRAGMENT_DETAIL_CONTROL", UserSession.CurrentRegistryId);

            foreach (STD_GUI_CONTROL dbItem in controls)
            {
                Control userControl = null;

                userControl = PanelFragmentDetails.FindControl(dbItem.USER_CONTROL_ID);
                if (userControl == null)
                {
                    userControl = PanelDimension.FindControl(dbItem.USER_CONTROL_ID);
                }
                if (userControl != null)
                {
                    BaseControlLabel baseControl = (BaseControlLabel)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL);
                }
            }
        }
    }
}
